IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[RC_DEB_HISTORICO_CPL_RC_VD_CONV]') 
					AND type in (N'U')) 
BEGIN
CREATE TABLE [dbo].[RC_DEB_HISTORICO_CPL_RC_VD_CONV](
	[CD_CTR] [int] NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_CTR_CONV] [int] NOT NULL,
	[VLR_CONV_SLD] [money] NOT NULL,
 CONSTRAINT [PK_RC_DEB_HISTORICO_CPL_RC_VD_CONV] PRIMARY KEY CLUSTERED 
(
	[CD_CTR] ASC,
	[CD_EMP] ASC,
	[CD_CTR_CONV] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[RC_DEB_HISTORICO_CPL_RC_VD_CONV] ADD  CONSTRAINT [DF_RC_DEB_HISTORICO_CPL_RC_VD_CONV_CD_CTR]  DEFAULT ((0)) FOR [CD_CTR]

ALTER TABLE [dbo].[RC_DEB_HISTORICO_CPL_RC_VD_CONV] ADD  CONSTRAINT [DF_RC_DEB_HISTORICO_CPL_RC_VD_CONV_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[RC_DEB_HISTORICO_CPL_RC_VD_CONV] ADD  CONSTRAINT [DF_RC_DEB_HISTORICO_CPL_RC_VD_CONV_CD_CTR_CONV]  DEFAULT ((0)) FOR [CD_CTR_CONV]

ALTER TABLE [dbo].[RC_DEB_HISTORICO_CPL_RC_VD_CONV] ADD  CONSTRAINT [DF_RC_DEB_HISTORICO_CPL_RC_VD_CONV_VLR_CONV_SLD]  DEFAULT ((0)) FOR [VLR_CONV_SLD]

ALTER TABLE [dbo].[RC_DEB_HISTORICO_CPL_RC_VD_CONV]  WITH CHECK ADD  CONSTRAINT [FK_RC_DEB_HISTORICO_CPL_RC_VD_CONV_RC_DEB_HISTORICO] FOREIGN KEY([CD_CTR])
REFERENCES [dbo].[RC_DEB_HISTORICO] ([CD_CTR])

ALTER TABLE [dbo].[RC_DEB_HISTORICO_CPL_RC_VD_CONV] CHECK CONSTRAINT [FK_RC_DEB_HISTORICO_CPL_RC_VD_CONV_RC_DEB_HISTORICO]

ALTER TABLE [dbo].[RC_DEB_HISTORICO_CPL_RC_VD_CONV]  WITH CHECK ADD  CONSTRAINT [FK_RC_DEB_HISTORICO_CPL_RC_VD_CONV_RC_VD_CONV] FOREIGN KEY([CD_EMP], [CD_CTR_CONV])
REFERENCES [dbo].[RC_VD_CONV] ([CD_EMP], [CD_CTR])
ON UPDATE CASCADE
ON DELETE CASCADE

ALTER TABLE [dbo].[RC_DEB_HISTORICO_CPL_RC_VD_CONV] CHECK CONSTRAINT [FK_RC_DEB_HISTORICO_CPL_RC_VD_CONV_RC_VD_CONV]
end